from yaphone.newpdater.src.admin import models as admin_models
from yaphone.newpdater.src.admin.views import base, roles
from yaphone.newpdater.src.common.databases import updater_db

CATEGORY = 'Admin'

base.admin_views.add_views(
    roles.UsersView(
        admin_models.AdminUser,
        session=updater_db.session,
        name='Users',
        category=CATEGORY,
    ),
    roles.RolesView(
        admin_models.AdminRoles,
        session=updater_db.session,
        name='Roles',
        category=CATEGORY,
    ),
)


def init_app(app):
    base.admin_views.url = app.config.get('ADMIN_URL')
    base.admin_views.init_app(app)
