from yaphone.newpdater.src.admin import repository


def get_user(username):
    user = repository.find_user(username=username)
    if not user:
        user = repository.add_user(username=username, email=f'{username}@yandex-team.ru')
    return user


def get_anonymous():
    return repository.get_anonymous()


def get_all_users():
    return repository.find_all_users()


def get_roles_description():
    return repository.find_roles_description()


def add_role(username, role):
    user = get_user(username)
    if not user.has_role(role):
        return repository.add_role(user, role)


def delete_role(username, role):
    user = get_user(username)
    if user.has_role(role):
        repository.delete_role(user, role)
