from wtforms.fields import SelectField

from yaphone.newpdater.src.admin.views.base import AdminModelView
from yaphone.newpdater.src.admin import models


class UsersView(AdminModelView):
    access_roles = (models.ROLE_ADMIN,)

    form_widget_args = dict(
        roles=dict(disabled=True),
        created_on=dict(readonly=True),
        updated_on=dict(readonly=True),
    )


class RolesView(AdminModelView):
    access_roles = (models.ROLE_ADMIN,)

    form_extra_fields = dict(
        type=SelectField(choices=[(r, r) for r in models.ROLES])
    )
