import logging

import mongoengine as me
from flask_migrate import Migrate
from flask_sqlalchemy import SQLAlchemy
from retrying import retry
from sqlalchemy import exc

from yaphone.newpdater.src.common.mongo_tools import make_mongo_uri

updater_db = SQLAlchemy()
migrate = Migrate()

logger = logging.getLogger(__name__)


def should_retry_on_exception(exception) -> bool:
    if isinstance(exception, exc.OperationalError):
        logger.warning('Raised a db exception "%s". Rollback and retry...', str(exception))
        updater_db.session.rollback()
        return True
    else:
        return False


on_error_retry = retry(
    stop_max_attempt_number=3,
    wait_fixed=800,
    retry_on_exception=should_retry_on_exception,
)


# Called by src/core/app.py
def init_app(app):
    updater_db.init_app(app)
    migrate.init_app(app, updater_db)
    me.connect(
        db=app.config['LOCALIZATION_MONGO_DBNAME'],
        host=app.config.get('MONGO_URI', make_mongo_uri(app.config, 'MONGO_DB_NAME'))
    )
