# Partially taken from:
#  yaphone/updater/src/updater/mongo.py
#
# See:
#  yaphone/updater/src/updater/mongo.py
#  yaphone/advisor/src/setup_wizard/models.py
#  yaphone/jafar/src/jafar/promo/models.py
#
# TODO:
#   If all models listed above will be merged to a new single model, use the new one.
#   OR move everything to updater, see ADVISOR-2294
import mongoengine as me

from yaphone.utils.parsers.parsers import DEFAULT_LANGUAGE


class LangSpecificValues(me.EmbeddedDocument):
    lang = me.StringField()
    title = me.StringField()
    description = me.StringField()


class YandexDistributedApp(me.Document):
    package_name = me.StringField(required=True, unique=True)
    texts = me.ListField(field=me.EmbeddedDocumentField(LangSpecificValues))

    # TODO: in reality, we have a text for a DEFAULT_LANGUAGE only. Reduce redundancy while resolving ADVISOR-2376
    def get_title(self, language):
        titles = {item.lang: item.title for item in self.texts}
        return titles.get(language) or titles.get(DEFAULT_LANGUAGE)

    meta = {
        'strict': False,
        'indexes': ['package_name'],
        'index_background': True,
    }
