def make_mongo_uri(config, db_key):
    hosts = ['%s:%s' % (item, config['MONGO_PORT']) for item in config['MONGO_HOST']]

    return 'mongodb://{username}:{password}@{hosts}/{database}'.format(
        username=config['MONGO_USERNAME'],
        password=config['MONGO_PASSWORD'],
        hosts=','.join(hosts),
        database=config[db_key]
    )
