from typing import Type

from marshmallow import Schema, post_dump
from marshmallow_mongoengine import ModelSchema

from yaphone.newpdater.src.common.models import YandexDistributedApp


def serialize(schema: Type[Schema], data):
    return schema().dump(obj=data).data


def serialize_many(schema: Type[Schema], data: list):
    return schema().dump(obj=data, many=True).data


def deserialize(serializer, data, session):
    return serializer().load(data, session=session).data


class NullRemoverMixin:

    @post_dump
    def remove_skip_values(self, data):
        return {
            key: value for key, value in data.items()
            if value is not None
        }


class YandexDistributedSerializer(ModelSchema):
    class Meta:
        model = YandexDistributedApp
