import ujson
from flask import Response
from werkzeug.urls import iri_to_uri


class JsonResponse(Response):
    default_mimetype = 'application/json'

    def __init__(self, response, escape_forward_slashes=False, *args, **kwargs):
        response = ujson.dumps(response, escape_forward_slashes=escape_forward_slashes)
        super().__init__(response, *args, **kwargs)


class Redirect(Response):
    default_status = 302

    def __init__(self, response, *args, **kwargs):
        response = iri_to_uri(response, safe_conversion=True)
        headers = {'Location': response}
        super().__init__(response, headers=headers, *args, **kwargs)
