import ylog
from werkzeug.datastructures import EnvironHeaders


class YLogMiddleware:
    def __init__(self, app):
        self.app = app

    def __call__(self, environ, start_response):
        headers = EnvironHeaders(environ)
        with ylog.context.log_context(
                headers=dict(headers),
                request_id=headers.get('X-Request-Id') or headers.get('X-Req-Id'),
        ):
            return self.app(environ, start_response)
