from yaphone.newpdater.src.admin.idm import api as idm_route
from yaphone.newpdater.src.download.routes import api as download_route
from yaphone.newpdater.src.health.views import api as health_route
from yaphone.newpdater.src.prebuilt.routes import api as prebuilt_route
from yaphone.newpdater.src.settings.routes import api as settings_api
from yaphone.newpdater.src.store.routes import api as store_route
from yaphone.newpdater.src.subscription.routes import api as subscription_route
from yaphone.newpdater.src.updates.routes import (
    api as updates_route,
    api_v2 as updates_v2_route,
    api_v3 as updates_v3_route,
    int_api as updates_int_route,
)
from yaphone.newpdater.src.admin import routes


# Called by src/core/app.py
def init_app(app):
    app.register_blueprint(health_route)
    app.register_blueprint(subscription_route)
    app.register_blueprint(settings_api)
    app.register_blueprint(updates_route)
    app.register_blueprint(updates_v2_route)
    app.register_blueprint(updates_v3_route)
    app.register_blueprint(updates_int_route)
    app.register_blueprint(store_route)
    app.register_blueprint(download_route)
    app.register_blueprint(idm_route)
    app.register_blueprint(prebuilt_route)
    routes.init_app(app)
