import logging
import yenv

from raven.contrib.flask import Sentry
from raven.handlers.logging import SentryHandler
from raven.conf import setup_logging

sentry = Sentry()

logger = logging.getLogger(__name__)


# Called by src/core/app.py
def init_app(app):
    if yenv.type == 'development':
        logger.warning('Sentry is not configured')
        return

    sentry.init_app(app, dsn=app.config['SENTRY_DSN'], level=logging.WARNING)
    handler = SentryHandler(sentry.client)
    handler.setLevel(app.config['SENTRY_LEVEL'])

    sentry.client.error_logger.propagate = True
    sentry.client.uncaught_logger.propagate = True

    if not setup_logging(handler, exclude=()):
        logger.error('Sentry is not configured')
