import hashlib

from yaphone.newpdater.src.common.databases import on_error_retry
from yaphone.newpdater.src.common.exceptions import UpdateNotFound
from yaphone.newpdater.src.download.models import SetupWizardUpdate


def get_branch_name(package_name):
    return hashlib.md5(package_name.encode()).hexdigest()


@on_error_retry
def find_update_by_package(package_name):
    branch = get_branch_name(package_name)
    update = SetupWizardUpdate.query.filter_by(
        branch=branch,
    ).order_by(
        SetupWizardUpdate.version_code.desc()
    ).first()

    if update:
        return update.branch, update.filename
    else:
        raise UpdateNotFound(package_name, 'setup wizard download')
