import logging
from werkzeug.exceptions import NotFound

from yaphone.newpdater.src.common import exceptions, s3mds
from yaphone.newpdater.src.download.repository import find_update_by_package

logger = logging.getLogger(__name__)

S3_DIRECTORY = 'setup_wizard'


def get_sw_url(package_name):
    try:
        branch, filename = find_update_by_package(package_name)
    except exceptions.UpdateNotFound:
        error_massage = f'Package {package_name} not found in setup wizard promo storage'
        logger.info(error_massage)
        raise NotFound(error_massage)
    key = f'{S3_DIRECTORY}/{branch}/{filename}'
    return s3mds.client.make_url(key)
