import pytest
from flask import Flask

from .fixtures import EXISTING_UPDATE_PACKAGE_NAME, EXISTING_UPDATE, NON_EXISTENT_PACKAGE_NAME
from yaphone.newpdater.src.common import databases
from yaphone.newpdater.src.core import settings, routes
from yaphone.newpdater.src.core.app import RegexpConverter
from yaphone.newpdater.src.download.models import SetupWizardUpdate

DOWNLOAD_URL = 'api/v2/download'


@pytest.fixture
def client():
    app = Flask(__name__)
    app.config.from_object(settings.LocalTestConfig)
    app.url_map.converters['re'] = RegexpConverter
    routes.init_app(app)
    databases.init_app(app)
    app.app_context().push()
    databases.updater_db.create_all()

    update = SetupWizardUpdate(**EXISTING_UPDATE)

    session = databases.updater_db.session
    session.add(update)
    session.commit()

    yield app.test_client()

    session.remove()
    databases.updater_db.drop_all()


def test_get_update_correct_redirect(client, make_s3_url):
    resp = client.get(DOWNLOAD_URL, query_string=dict(package_name=EXISTING_UPDATE_PACKAGE_NAME))

    assert resp.status_code == 302

    link = next(resp.response).decode()
    assert link.endswith(f'setup_wizard/{EXISTING_UPDATE["branch"]}/{EXISTING_UPDATE["filename"]}')


def test_get_update_not_found(client, make_s3_url):
    resp = client.get(DOWNLOAD_URL, query_string=dict(package_name=NON_EXISTENT_PACKAGE_NAME))

    assert resp.status_code == 404
