import pytest

from werkzeug.exceptions import NotFound

from yaphone.newpdater.src.common.exceptions import UpdateNotFound
from yaphone.newpdater.src.download.service import get_sw_url

from .fixtures import EXISTING_UPDATE_PACKAGE_NAME, EXISTING_UPDATE, NON_EXISTENT_PACKAGE_NAME


@pytest.fixture
def find_update_by_package(monkeypatch):

    def find_update_by_package(package_name):
        if package_name == EXISTING_UPDATE_PACKAGE_NAME:
            return EXISTING_UPDATE['branch'], EXISTING_UPDATE['filename']
        elif package_name == NON_EXISTENT_PACKAGE_NAME:
            raise UpdateNotFound(package_name, 'test')

    monkeypatch.setattr('yaphone.newpdater.src.download.service.find_update_by_package', find_update_by_package)
    return find_update_by_package


def test_get_sw_url_success(find_update_by_package, make_s3_url):
    url = get_sw_url(EXISTING_UPDATE_PACKAGE_NAME)
    assert url == f's3://test/setup_wizard/{EXISTING_UPDATE["branch"]}/{EXISTING_UPDATE["filename"]}'


def test_get_sw_url_fail(find_update_by_package, make_s3_url):
    with pytest.raises(NotFound, match=NON_EXISTENT_PACKAGE_NAME):
        get_sw_url(NON_EXISTENT_PACKAGE_NAME)
