from flask import request
from flask.views import MethodView

from yaphone.newpdater.src.common import validation, views
from yaphone.newpdater.src.download import service, validators


# noinspection PyMethodMayBeStatic
class DownloadView(MethodView):
    def get(self, **_):
        data = validation.validate(validators.DownloadValidator, request.args)
        url = service.get_sw_url(data['package_name'])
        return views.Redirect(url)
