import logging
from flask import current_app

from yaphone.newpdater.src.common.databases import updater_db

logger = logging.getLogger(__name__)


def get_health():
    return True


def migration_applied():
    with updater_db.engine.connect() as connection:
        result = connection.execute('select version_num from alembic_version')
        if not result:
            logger.info("Can't obtain latest applied migration")
            return False
        latest_applied_migration = list(result)[0][0]

    latest_available_migration = current_app.config['NEWEST_MIGRATION']
    if not latest_applied_migration:
        logger.info("Can't obtain latest available migration")
        return False
    return latest_applied_migration in latest_available_migration
