from flask import Blueprint, Response

from yaphone.newpdater.src.health import service

api = Blueprint('health', __name__, url_prefix='/')


@api.route('/ping')
def ping():
    if service.get_health():
        return Response(status=200)
    else:
        return Response(status=500)


@api.route('/check_migrations')
def check_migrations():
    if service.migration_applied():
        return Response(status=200)
    else:
        return Response(status=500)
