from yaphone.newpdater.src.common.exceptions import AppNotFound
from yaphone.newpdater.src.common.models import DEFAULT_LANGUAGE
from yaphone.newpdater.src.subscription import SubscriptionRepo


class SubscriptionMockRepo(SubscriptionRepo):

    def __init__(self, distributed_apps, subscriptions):
        self.distributed_apps = distributed_apps
        self.subscriptions = subscriptions

    def add_subscription(self, uuid, package_name):
        acceptable = self.find_distributed_app(package_name)
        if acceptable:
            self.subscriptions.append({'device_id': uuid, 'package_name': package_name})

    def remove_subscription(self, uuid, package_name):
        for sub in self.subscriptions:
            if sub.get('device_id') == uuid and sub.get('package_name') == package_name:
                del sub['device_id']
                return True
        return False

    def find_by_device_id(self, device_id):
        result = []
        for sub in self.subscriptions:
            if sub['device_id'] == device_id:
                result.append(sub)
        return result

    def find_all(self):
        return self.subscriptions

    def find_distributed_app(self, package_name, lang=DEFAULT_LANGUAGE):
        for app in self.distributed_apps:
            if app['package_name'] == package_name:
                return app

        raise AppNotFound(package_name, 'SubscriptionMock')

    def is_distributed_app(self, package_name):
        for app in self.distributed_apps:
            if app['package_name'] == package_name:
                return True

        return False
