from sqlalchemy import func

from yaphone.newpdater.src.common.databases import updater_db as db


class PrebuiltApp(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    filename = db.Column(db.String, nullable=False)
    local_name = db.Column(db.String, nullable=False)
    privileged = db.Column(db.Boolean, nullable=True)
    platform_apis = db.Column(db.Boolean, nullable=True)
    module_name = db.Column(db.String, nullable=True)
    module_class = db.Column(db.String, nullable=True)
    certificate = db.Column(db.String, nullable=True)
    owner = db.Column(db.String, nullable=True)
    overrides_packages = db.Column(db.String, nullable=True)
    module_tags = db.Column(db.String, nullable=True)
    updated_at = db.Column(
        name='updated_at',
        type_=db.DateTime(timezone=True),
        server_default=func.now(),
        onupdate=func.now(),
        nullable=False
    )
    device_firmware_id = db.Column(db.Integer, db.ForeignKey('device_firmware.id'), nullable=False)


class DeviceFirmware(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    device = db.Column(db.String, nullable=False)
    target = db.Column(db.String, nullable=False)
    os_version = db.Column(db.String, nullable=False)
    build_version = db.Column(db.String, nullable=False)

    app = db.relationship(PrebuiltApp, backref='device_firmware', lazy='immediate')

    def __repr__(self):
        return f'{self.device} [{self.target}]: {self.os_version}_{self.build_version}'
