from yaphone.newpdater.src.common.databases import on_error_retry
from yaphone.newpdater.src.prebuilt.models import PrebuiltApp, DeviceFirmware


class PrebuiltRepo:
    def __init__(self, session):
        self.session = session

    @on_error_retry
    def find_device_firmware(self, device, target, os_version, build_version):
        model = DeviceFirmware
        return self.session.query(
            model
        ).filter(
            model.device.ilike(device),
            model.target.ilike(target),
            model.os_version.ilike(os_version),
            model.build_version.ilike(build_version),
        ).first()

    @on_error_retry
    def find_apps_by_device_id(self, device_id):
        return self.session.query(
            PrebuiltApp
        ).filter_by(
            device_firmware_id=device_id
        ).all()

    @on_error_retry
    def find_filename_by_id(self, id):
        return self.session.query(
            PrebuiltApp.filename
        ).filter_by(
            id=id
        ).first().filename
