from flask import Blueprint

from yaphone.newpdater.src.admin.views.base import admin_views
from yaphone.newpdater.src.common.databases import updater_db as db
from yaphone.newpdater.src.prebuilt import models, views

CATEGORY = 'Prebuilt'

api = Blueprint('prebuilt', __name__, url_prefix='/api/v2')

api.add_url_rule(
    '/prebuilt',
    view_func=views.PrebuiltView.as_view('prebuilt'),
    methods=['GET'],
)

admin_views.add_views(
    views.PrebuiltAdminView(
        models.PrebuiltApp,
        session=db.session,
        name='Apps',
        category=CATEGORY,
    ),
    views.DeviceAdminView(
        models.DeviceFirmware,
        session=db.session,
        name='Devices',
        category=CATEGORY,
    ),
)
