import logging

from werkzeug.exceptions import NotFound

from yaphone.newpdater.src.common.s3mds import s3key
from yaphone.newpdater.src.common.serialization import serialize_many
from yaphone.newpdater.src.prebuilt.serializers import PrebuiltSerializer

logger = logging.getLogger(__name__)


class PrebuiltService:
    key_maker = s3key.KeyMaker('prebuilt/{device}/{target}/{filename}')

    def __init__(self, loader, repository):
        self.loader = loader
        self.repository = repository

    def make_s3_urls(self, device, target, apps):
        for app in apps:
            key_dict = dict(device=device, target=target, filename=app['filename'])
            key = self.key_maker.make_key(key_dict)
            app['url'] = self.loader.make_url(key)

        return apps

    def get_prebuilt_apps(self, device, target, os_version, build_version, *_):
        device_firmware = self.repository.find_device_firmware(device, target, os_version, build_version)

        if not device_firmware:
            raise NotFound(
                f'No such device firmware {device} [{target}]: {os_version}_{build_version}')

        apps = self.repository.find_apps_by_device_id(device_firmware.id)

        if apps:
            apps = serialize_many(PrebuiltSerializer, apps)
            return self.make_s3_urls(device, target, apps)
        else:
            raise NotFound(
                f'No prebuilt found for {device} [{target}]: {os_version}_{build_version}')
