from collections import namedtuple

from yaphone.newpdater.src.common.localization import service

Item = namedtuple('Item', ['name', 'value'])


class UserSpecificConfigMock:
    def __init__(self, *args, **kwargs):
        pass

    def get_all_enabled_items(self):
        return [Item(name='client.notifications', value='all')]


def init_app(app):
    """
    Since localization can't be initialized with mongomock, we mock the init_app() function.
    :param app: test Flask app
    """
    project_names = app.config['LOCALIZATION_PROJECTS']
    service.configure(
        project_names['server'],
        project_names['client'],
        project_names['translate']
    )
