from flask import request, jsonify
from flask.views import MethodView

from yaphone.newpdater.src.common.localization import ConfigFactory
from yaphone.newpdater.src.common.serialization import serialize_many
from yaphone.newpdater.src.common.validation import validate
from yaphone.newpdater.src.settings.serializers import LocalizationItemSerializer
from yaphone.newpdater.src.settings.validators import SettingsHeadersValidator


class SettingsView(MethodView):

    def get(self, **_):
        headers = validate(SettingsHeadersValidator, request.headers)
        factory = ConfigFactory(**headers)
        items = factory.client_config.get_all_enabled_items()
        settings = serialize_many(LocalizationItemSerializer, items)
        return jsonify(settings)
