import logging

from sqlalchemy.orm import load_only
from werkzeug.exceptions import NotFound
from yaphone.newpdater.src.common.databases import updater_db as db, on_error_retry
from yaphone.newpdater.src.store.models import Category, StoreApp, Screenshot

logger = logging.getLogger(__name__)


# noinspection PyMethodMayBeStatic
class StoreRepo:
    @on_error_retry
    def find_apps_by_category(self, category: str):
        apps = StoreApp.query.filter_by(
            category_id=category,
            enabled=True,
        ).outerjoin(
            Screenshot
        ).all()
        return apps

    @on_error_retry
    def find_apps(self):
        apps = StoreApp.query.filter_by(
            enabled=True,
        ).all()
        return apps

    @on_error_retry
    def find_url_by_package(self, package_name: str):
        app = StoreApp.query.filter_by(
            package_name=package_name,
            enabled=True,
        ).options(load_only("s3key")).first()
        db.session.commit()
        if not app:
            error_message = f'No app found with package="{package_name}".'
            logger.exception(error_message)
            raise NotFound(error_message)
        return app.url

    @on_error_retry
    def find_categories(self):
        categories = Category.query.all()
        return categories

    @on_error_retry
    def add_installation(self, package_name):
        edited = StoreApp.query.filter_by(
            package_name=package_name
        ).update(
            {StoreApp.installs_num: StoreApp.installs_num + 1},
            synchronize_session='fetch'
        )
        db.session.commit()
        return edited
