import logging
import warnings

from flask import Blueprint

from yaphone.newpdater.src.admin.views.base import admin_views
from yaphone.newpdater.src.common.databases import updater_db as db
from yaphone.newpdater.src.store import admin, models, views

logging.captureWarnings(True)
warnings.filterwarnings('ignore', 'Fields missing from ruleset', UserWarning)

CATEGORY = 'Store'

api = Blueprint('store', __name__, url_prefix='/api/v2')

api.add_url_rule(
    '/categories',
    view_func=views.CategoriesView.as_view('get_categories'),
    methods=['GET'],
)
api.add_url_rule(
    '/apps',
    view_func=views.AppsView.as_view('get_apps'),
    methods=['GET'],
)
api.add_url_rule(
    '/app',
    view_func=views.AppView.as_view('get_app'),
    methods=['GET'],
)
api.add_url_rule(
    '/installed_app',
    view_func=views.AppInstallsView.as_view('update_app_installs_num'),
    methods=['POST'],
)

admin_views.add_views(
    admin.StoreAppView(
        models.StoreApp,
        session=db.session,
        name='Apps',
        category=CATEGORY,
    ),
    admin.ScreenshotView(
        models.Screenshot,
        session=db.session,
        name='Screenshots',
        category=CATEGORY,
    ),
    admin.CategoryView(
        models.Category,
        session=db.session,
        name='Categories',
        category=CATEGORY,
    ),
)
