from flask import url_for
from marshmallow import fields
from marshmallow_sqlalchemy import ModelSchema

from yaphone.newpdater.src.common.serialization import NullRemoverMixin
from yaphone.newpdater.src.store.models import StoreApp, Category, Screenshot


class ScreenshotSerializer(ModelSchema):
    class Meta:
        model = Screenshot


class CategorySerializer(ModelSchema):
    class Meta:
        model = Category
        fields = (
            'id',
            'name',
        )


def wrap_download_url(obj):
    return url_for('.get_app', package_name=obj.package_name, _external=True)


class StoreAppSerializer(NullRemoverMixin, ModelSchema):
    screenshots = fields.List(fields.Nested(ScreenshotSerializer, only=('url', 'preview_url')))
    updated_at = fields.Integer(attribute='uploaded_at')
    download_url = fields.Function(wrap_download_url)

    class Meta:
        model = StoreApp
        fields = (
            'app_name',
            'package_name',
            'version_name',
            'version_code',
            'size',
            'updated_at',
            'company_name',
            'description',
            'restriction_age',
            'installs_num',
            'download_url',
            'banner_url',
            'eula_url',
            'privacy_url',
            'screenshots',
        )
