import mock
import pytest
from flask import Flask

from .fixtures import OKKO_APP
from .unittests import service, all_apps, categories
from yaphone.newpdater.src.common import databases, s3mds
from yaphone.newpdater.src.core import settings, routes
from yaphone.newpdater.src.core.app import RegexpConverter


@pytest.fixture
def s3_client():
    app = Flask(__name__)
    app.config.from_object(settings.LocalTestConfig)
    app.url_map.converters['re'] = RegexpConverter
    routes.init_app(app)
    databases.init_app(app)
    s3mds.init_app(app)
    with app.app_context():
        db = databases.updater_db
        db.create_all()
        db.session.commit()
        yield app.test_client()
        db.drop_all()


@mock.patch('yaphone.newpdater.src.store.views.service', service(categories(), all_apps()))
class TestLinks:
    url = 'api/v2/app'

    def test_s3(self, s3_client):
        response = s3_client.get(
            self.url,
            query_string=f'package_name={OKKO_APP["package_name"]}',
        )
        url = response.headers.get('Location')
        assert url == OKKO_APP['download_url']
