from yaphone.newpdater.src.store import StoreRepo


class StoreMockRepo(StoreRepo):

    def __init__(self, apps: list, categories: list):
        super().__init__()
        self.apps = apps
        self.categories = categories

    def find_apps(self):
        return self.apps

    def find_apps_by_category(self, category: str):
        return [app for app in self.apps if app['category'] == category]

    def find_url_by_package(self, package_name: str):
        for app in self.apps:
            if app['package_name'] == package_name:
                return app['download_url']
        else:
            return None

    def find_categories(self):
        return self.categories
