import logging

from flask import request, redirect, Response
from flask.views import MethodView
from werkzeug.exceptions import NotFound

from yaphone.newpdater.src.common import validation, views, serialization
from yaphone.newpdater.src.store import service, validators, serializers

logger = logging.getLogger(__name__)


class CategoriesView(MethodView):
    def get(self):
        categories = service.get_categories()
        if not categories:
            error_message = 'No categories found.'
            logger.exception(error_message)
            raise NotFound(error_message)
        result = serialization.serialize_many(serializers.CategorySerializer, categories)
        return views.JsonResponse(result)


class AppView(MethodView):
    def get(self):
        args = validation.validate(validators.AppUrlRequestValidator, request.args)
        package_name = args['package_name']
        url = service.get_app_url(package_name)
        return redirect(url)


class AppsView(MethodView):
    def get(self):
        args = validation.validate(validators.AppsRequestValidator, request.args)
        apps = service.get_apps(request=request, category=args.get('category'))
        result = serialization.serialize_many(serializers.StoreAppSerializer, apps)
        return views.JsonResponse({'data': result})


class AppInstallsView(MethodView):
    def post(self):
        args = validation.validate(validators.AppUrlRequestValidator, request.args)
        package_name = args['package_name']
        service.add_installation(package_name)
        return Response()
