import logging

from werkzeug.exceptions import NotAcceptable, NotFound

logger = logging.getLogger(__name__)


class SubscriptionService:
    def __init__(self, repo):
        self.repo = repo

    def subscribe(self, device_id, package_name):
        yandex_distributed = self.repo.is_distributed_app(package_name)
        if yandex_distributed:
            self.repo.add_subscription(device_id, package_name)
        else:
            raise NotAcceptable('App is not being watched')

    def unsubscribe(self, uuid, package_name):
        removed = self.repo.remove_subscription(uuid, package_name)
        if not removed:
            raise NotFound(description='There is no such subscription.')

    def list_devices(self):
        return ', '.join([sub['package_name'] for sub in self.repo.find_all()])
