import ujson
from marshmallow import Schema, pre_load, ValidationError
from marshmallow.fields import String


class RequestValidator(Schema):
    device_id = String(required=True)
    package_name = String(required=True)

    @pre_load
    def deserialize(self, data, **kwargs):
        if not data:
            raise ValidationError('No payload provided')
        try:
            return ujson.loads(data)
        except ValueError:
            raise ValidationError('Incorrect json provided')
