import logging

from flask import request, Response
from flask.views import MethodView

from yaphone.newpdater.src.common import validation
from yaphone.newpdater.src.subscription import service, validators

logger = logging.getLogger(__name__)


class SubscribeView(MethodView):
    def post(self, **_):
        body = validation.validate(validators.RequestValidator, request.data)
        device_id = body['device_id']
        package_name = body['package_name']
        service.subscribe(device_id, package_name)
        return Response(status=200)


class UnsubscribeView(MethodView):
    def post(self, **_):
        body = validation.validate(validators.RequestValidator, request.data)
        device_id = body['device_id']
        package_name = body['package_name']
        service.unsubscribe(device_id, package_name)
        return Response(status=200)


class ListView(MethodView):
    def get(self, **_):
        return Response(service.list_devices(), status=200)
