from yaphone.newpdater.src.common import s3mds
from yaphone.newpdater.src.common.databases import updater_db as db
from yaphone.newpdater.src.common.s3mds.service import FileLoaderService
from yaphone.newpdater.src.subscription import subscriptions_repo
from yaphone.newpdater.src.updates.repository.firmware import FirmwareRepo
from yaphone.newpdater.src.updates.repository.local_updates import LocalUpdateRepo
from yaphone.newpdater.src.updates.service import LocalUpdateService, FirmwareService

loader = FileLoaderService(client=s3mds.client)
firmware_service = FirmwareService(
    loader=loader,
    repository=FirmwareRepo(db.session),
)
updates_service = LocalUpdateService(
    loader=loader,
    repository=LocalUpdateRepo(db.session),
    subscriptions_repo=subscriptions_repo,
)
