import logging
import warnings

from flask import Blueprint

from yaphone.newpdater.src.admin.views.base import admin_views
from yaphone.newpdater.src.common.databases import updater_db as db
from yaphone.newpdater.src.updates import views, models
from yaphone.newpdater.src.updates.admin import FirmwareChangelogsView, FirmwareUpdatesView, LocalUpdatesView

logging.captureWarnings(True)
warnings.filterwarnings('ignore', 'Fields missing from ruleset', UserWarning)

CATEGORY = 'Updates'

api = Blueprint('updates', __name__, url_prefix='/api/v<re("1|2"):version>')
api_v2 = Blueprint('updates_v2', __name__, url_prefix='/api/v2')
api_v3 = Blueprint('updates_v3', __name__, url_prefix='/api/v3')
int_api = Blueprint('internal_api', __name__, url_prefix='/int-api/v2')

int_api.add_url_rule(
    '/upload',
    view_func=views.AppUploadView.as_view('upload'),
    methods=['POST'],
)
int_api.add_url_rule(
    '/ota_upload',
    view_func=views.OtaUploadView.as_view('ota_upload'),
    methods=['POST'],
)
api.add_url_rule(
    '/updates',
    view_func=views.UpdatesView.as_view('check_for_updates'),
    methods=['GET'],
)
api_v2.add_url_rule(
    '/ota',
    view_func=views.OtaView.as_view('get_ota_update'),
    methods=['GET'],
)
int_api.add_url_rule(
    '/list_ota',
    view_func=views.ListOtaView.as_view('get_ota_list'),
    methods=['GET'],
)
api_v3.add_url_rule(
    '/ota',
    view_func=views.OtaV3View.as_view('get_ota_update_v3'),
    methods=['GET'],
)

api_v3.add_url_rule(
    '/updates',
    view_func=views.UpdatesV3View.as_view('check_for_updates_v3'),
    methods=['POST'],
)

admin_views.add_views(
    LocalUpdatesView(
        models.LocalUpdate,
        session=db.session,
        name='Local updates',
        category=CATEGORY,
    ),
    FirmwareUpdatesView(
        models.OtaUpdate,
        session=db.session,
        name='FOTA updates',
        category=CATEGORY,
    ),
    FirmwareChangelogsView(
        models.Changelog,
        session=db.session,
        name='FOTA Changelogs',
        category=CATEGORY,
    )
)
