import pytest
from flask import Flask

from yaphone.newpdater.src.common import databases, s3mds
from yaphone.newpdater.src.core import settings, routes
from yaphone.newpdater.src.core.app import RegexpConverter


def put_to_bucket(file, key):
    s3mds.client.upload_file(file, key)


def get_filedata(filename):
    return open(f'test/upload/fixtures/{filename}', 'rb'), filename


@pytest.fixture
def client():
    app = Flask(__name__)
    app.config.from_object(settings.LocalTestConfig)
    app.url_map.converters['re'] = RegexpConverter
    routes.init_app(app)
    databases.init_app(app)
    s3mds.init_app(app)
    with app.app_context():
        databases.updater_db.create_all()
        databases.updater_db.session.commit()

        yield app.test_client()

        databases.updater_db.drop_all()
