from yaphone.newpdater.src.updates.types import Product

EXISTING_DEVICE_OREO = Product(
    brand='Hikeen',
    product='RealtekATV',
    device='0000SB',
    version_release='8.1',
)
EXISTING_DEVICE_PIE = Product(
    brand='Hikeen',
    product='RealtekATV',
    device='0000SB',
    version_release='9.0',
)
EXISTING_RANDOM_CASE_DEVICE_PIE = Product(
    brand='hiKEEn',
    product='reALTekAtV',
    device='0000sB',
    version_release='9.0',
)
NON_EXISTENT_DEVICE = Product(
    brand='Faberlic',
    product='Antiblick',
    device='NoTV',
    version_release='-4,5'
)


def auto_ru_local_update(filename=None, branch=None, download_url=None, s3key=None):
    data = {
        'package_name': 'com.yandex.autoru',
        'version_code': 1,
        'version_name': '4.3.3',
        'size': 1234567,
        'app_name': 'AutoRu',
    }
    if filename:
        data['filename'] = filename
    if branch:
        data['branch'] = branch
    if download_url:
        data['download_url'] = download_url
    if s3key:
        data['s3key'] = s3key
    return data


def super_app_local_update(app_name='CYBER APP', filename=None, branch=None, download_url=None, s3key=None):
    """Default app_name is a translated app name"""
    data = {
        'package_name': 'com.yandex.superapp',
        'version_code': 2,
        'version_name': '2',
        'size': 987654321,
        'app_name': app_name,
    }
    if filename:
        data['filename'] = filename
    if branch:
        data['branch'] = branch
    if download_url:
        data['download_url'] = download_url
    if s3key:
        data['s3key'] = s3key
    return data


def home_app_local_update(filename=None, branch=None, download_url=None, s3key=None):
    data = {
        'package_name': 'ru.yandex.homeapp',
        'version_code': 98,
        'version_name': '1.0.0',
        'size': 10948375,
        'app_name': 'Home app',
    }
    if filename:
        data['filename'] = filename
    if branch:
        data['branch'] = branch
    if download_url:
        data['download_url'] = download_url
    if s3key:
        data['s3key'] = s3key
    return data


def ivi_local_update(filename=None, branch=None, download_url=None, s3key=None):
    data = {
        'package_name': 'ru.ivi.play',
        'version_code': 4227589,
        'version_name': '2.3.4',
        'size': 40582974,
        'app_name': 'ivi Player',
    }
    if filename:
        data['filename'] = filename
    if branch:
        data['branch'] = branch
    if download_url:
        data['download_url'] = download_url
    if s3key:
        data['s3key'] = s3key
    return data


def ignored_app_local_update(filename='ignored.apk', branch='dev', download_url=None, s3key=None):
    data = {
        'package_name': 'com.nemo.napp',
        'version_code': 1,
        'version_name': '1.1',
        'size': 1,
        'app_name': 'Ignored Application',
    }
    if filename:
        data['filename'] = filename
    if branch:
        data['branch'] = branch
    if download_url:
        data['download_url'] = download_url
    if s3key:
        data['s3key'] = s3key
    return data


PHONE_TRACKED_BUILDS = [
    {'branch': 'dev', 'package_name': 'com.yandex.superapp'},
    {'branch': 'dev', 'package_name': 'com.yandex.autoru'},
]
TV_TRACKED_BUILDS = [
    {'branch': 'tv_dev', 'package_name': 'ru.yandex.homeapp'},
    {'branch': 'tv_dev', 'package_name': 'ru.ivi.play'},
]
NO_PREFIX_TRACKED_BUILDS = [
    {'branch': 'dev', 'package_name': 'com.yandex.launcher.updaterapp'},
    {'branch': 'dev', 'package_name': 'com.yandex.launcher'},
    {'branch': 'dev', 'package_name': 'com.yandex.autoru'},
    {'branch': 'dev', 'package_name': 'com.yandex.superapp'},
]

OREO_DEV_OTA_UPDATE = {
    'id': 1,
    'os_version': EXISTING_DEVICE_OREO.version,
    'build_version': '194',
    'manufacturer': EXISTING_DEVICE_OREO.brand,
    'product_name': EXISTING_DEVICE_OREO.name,
    'model': EXISTING_DEVICE_OREO.device,
    'filename': 'fw_194.zip',
    'branch': 'dev',
}
PIE_TV_DEV_OTA_UPDATE = {
    'id': 2,
    'os_version': EXISTING_DEVICE_PIE.version,
    'build_version': '41',
    'manufacturer': EXISTING_DEVICE_PIE.brand,
    'product_name': EXISTING_DEVICE_PIE.name,
    'model': EXISTING_DEVICE_PIE.device,
    'filename': 'fw_41.zip',
    'branch': 'tv_dev',
}
OREO_PROD_OTA_UPDATE = {
    'id': 3,
    'os_version': EXISTING_DEVICE_OREO.version,
    'build_version': '194',
    'manufacturer': EXISTING_DEVICE_OREO.brand,
    'product_name': EXISTING_DEVICE_OREO.name,
    'model': EXISTING_DEVICE_OREO.device,
    'filename': 'fw_194.zip',
    'branch': 'prod',
}

OREO_DEV_OTA_TRACKED_BUILD = [
    {
        'version': '8.1',
        'branch': 'dev',
    },
    {
        'version': '9.0',
        'branch': 'tv_dev',
    },
]
OREO_TEST_OTA_TRACKED_BUILD = [{
    'version': '8.1',
    'branch': 'test',
}]
MM_DEV_OTA_TRACKED_BUILD = [{
    'version': '6.1',
    'branch': 'dev',
}]
