import ujson
from yaphone.localization import UserSpecificConfig, Translator

from yaphone.newpdater.src.common.exceptions import UpdateNotFound
from yaphone.newpdater.src.common.models import YandexDistributedApp
from yaphone.newpdater.src.updates.models import LocalUpdate, MarketUpdate, OtaUpdate


class UserConfigMock(UserSpecificConfig):
    import logging
    logger = logging.getLogger(__name__)

    def __init__(self, values):
        self.values = values
        super().__init__(None, None)

    def get_value(self, param_name, default_value=None, log_missing=True) -> str:
        return ujson.dumps(self.get_object(param_name, default_value, log_missing))

    def get_object(self, param_name, default_value=None, log_missing=True) -> list:
        value = self.values.get(param_name, default_value)
        self.logger.error('%s gets %s', param_name, value)
        return value

    def get_item(self, param_name):
        pass

    def get_user_info(self):
        pass

    def get_all_enabled_items(self):
        pass


class MockTranslator(Translator):

    def __init__(self, translations):
        self.translations = translations
        super().__init__(None, None)

    def translate(self, key):
        return self.translations.get(key, key)


class UpdatesMockRepo:

    def __init__(self, distributed_apps, local_updates, ota_updates, market_updates):
        self.local_updates = map(lambda d: LocalUpdate(**d), local_updates)
        self.market_updates = map(lambda d: MarketUpdate(**d), market_updates)
        self.ota_updates = map(lambda d: OtaUpdate(**d), ota_updates)
        self.distributed_apps = map(lambda d: YandexDistributedApp(**d), distributed_apps)

    def find_market_updates(self, filter_packages=None):
        if not filter_packages:
            raise UpdateNotFound('No packages provided', 'UpdatesMock')

        apps = [app for app in self.market_updates if app.package_name in filter_packages]

        if not apps:
            raise UpdateNotFound(filter_packages, 'UpdatesMock')
        else:
            return apps

    def find_local_updates(self, selections=None):
        if not selections:
            raise UpdateNotFound('No filters provided', 'UpdatesMock')

        apps = []
        for app in self.local_updates:
            for selection in selections:
                package_matches = app.package_name == selection['package_name']
                branch_matches = app.branch == selection.get('branch')
                if package_matches and branch_matches:
                    apps.append(app)

        if not apps:
            raise UpdateNotFound(selections, 'UpdatesMock')
        else:
            return apps

    def find_ota_update(self, os_version, branch, brand, product_name, model_name):
        msg = f'{os_version}, {branch}, {brand}/{product_name}/{model_name}'

        if not os_version or not branch:
            raise UpdateNotFound(msg, 'ota updates')

        for update in self.ota_updates:
            if all((
                update.os_version == os_version,
                update.branch == branch,
                update.manufacturer.lower() == brand.lower(),
                update.product_name.lower() == product_name.lower(),
                update.model.lower() == model_name.lower(),
            )):
                return update

        raise UpdateNotFound(msg, 'ota updates')

    def _find_app_updates(self, selections, model=None):
        pass
