from enum import Enum


class UpdateType:
    LOCAL = 'yandex'
    FIRMWARE = 'firmware'
    GOOGLE_PLAY = 'google_play'

    TYPES = (LOCAL, FIRMWARE, GOOGLE_PLAY)
    DEFAULT = (LOCAL,)


class PriorityEnum(Enum):
    NORMAL = 'NORMAL'
    SOFT_FORCED = 'SOFT_FORCED'
    FORCED = 'FORCED'

    def __str__(self):
        return self.value


class Product:

    def __init__(self, brand, product, device, version_release, **_):
        self.brand: str = brand  # ro.product.brand
        self.name: str = product  # ro.product.name
        self.device: str = device  # ro.product.device
        self.version: str = version_release
