#!/usr/bin/env python
# -*- coding: utf-8 -*-
import ast
import os
from datetime import date, datetime, timedelta

import pytz
from nile.api.v1 import statface as ns
from nile.api.v1.datetime import date_range

ADNETWORK_POSTBACKS_LOG_PATH = 'home/advisor/money-reports/adnetwork-postbacks/@date'
APPMETRIKA_LOG_PATH = '//logs/yandex-phone-metrika-mobile-log/1d/@date'
DATE_END = date.today() - timedelta(days=1)
DATE_END_APPREC = date.today() - timedelta(days=2)
DISTRIBUTION_REPORT_URL = "https://distribution.yandex.net/api/v2/statistics/basic/report/?lang=ru"
WEEKS_RECALC_BACK = 2
DATE_START = DATE_END - timedelta(weeks=WEEKS_RECALC_BACK)
DATES_LIST = set(date_range(DATE_START, DATE_END, step=1, stringify=True))
DATES_LIST_APPREC = set(date_range(DATE_START, DATE_END_APPREC, step=1, stringify=True))
JOB_ROOT = 'home/advisor/reports/launcher'
LAUNCHER_APIKEY = '37460'
LAUNCHER_SOFTID = '1029'
MAGIC_DATE_RANGE_STRING = '{%s..%s}' % (DATE_START, DATE_END)
MAGIC_DATE_RANGE_STRING_APPREC = '{%s..%s}' % (DATE_START, DATE_END_APPREC)
STAT_TOKEN = os.environ.get('STATFACE_TOKEN', '')
USERNAME = ''


def date_string_from_ts(ts):
    return datetime.fromtimestamp(
        int(ts)
    ).strftime('%Y-%m-%d')


def get_clid1(a, b):
    try:
        a, b = ast.literal_eval(a), ast.literal_eval(b)
        return str(dict(zip(a, b)).get('clid1', 'Empty')) or 'Empty'
    except ValueError:
        return 'Empty'


def ts_to_msk_date(ts):
    if not ts:
        ts = 0
    return utc_to_local(datetime.fromtimestamp(int(ts))).strftime('%Y-%m-%d')


def utc_to_local(utc_dt):
    LOCAL_TZ = pytz.timezone('Europe/Moscow')
    local_dt = utc_dt.replace(tzinfo=pytz.utc).astimezone(LOCAL_TZ)
    return LOCAL_TZ.normalize(local_dt)


def validate_unicode(text):
    try:
        text.decode('utf8')
    except (UnicodeDecodeError, AttributeError):
        text = 'bad encoded string'
    return text


def get_app_ids_from_dict(input_dict):
    return {
        app_id: project
        for project, app in input_dict.iteritems()
        for app_id in app.get('app_ids', [])
    }


def get_stat_client():
    return ns.StatfaceProductionClient(
        token=STAT_TOKEN
    )
