#!/usr/bin/env python
# -*- coding: UTF-8 -*-
"""
Takes Launcher events from metrika_mobile_log, separates by clid1. Draws stat report.
"""
import os
import sys

from common import get_stat_client

sys.path.insert(1, os.path.join(sys.path[0], '../..'))

import ast
import logging
from datetime import date, timedelta
from nile.api.v1 import clusters, aggregators as na, extractors as ne, statface as ns
from nile.api.v1.datetime import date_range
from qb2.api.v1 import filters as sf, extractors as se

# logging.basicConfig(level=logging.WARN)
logger = logging.getLogger(__name__)
_handler = logging.FileHandler(os.path.join(os.path.dirname(os.path.abspath(__file__)), 'log.txt'))
formatter = logging.Formatter('%(asctime)s %(levelname)s %(filename)s %(message)s')
_handler.setFormatter(formatter)
logger.addHandler(_handler)
logger.setLevel(logging.WARNING)

APIKEY = '37460'
WEEKS_RECALC_BACK = 2
DATE_END = date.today() - timedelta(days=1)
DATE_START = DATE_END - timedelta(weeks=WEEKS_RECALC_BACK)
DATES_LIST = list(date_range(DATE_START, DATE_END, step=1, stringify=True))
# '{2017-01-01..2017-10-31}'
MAGIC_DATE_RANGE_STRING = '..'.join([DATE_START.isoformat(), DATE_END.isoformat()]).join(['{', '}'])
JOB_ROOT = 'home/advisor/chikachoff/events'
OUTPUT_TABLE = '$job_root/clidded'
RAW_LOG_TABLE = '//logs/yandex-phone-metrika-mobile-log/1d/@date'
USERNAME = 'chikachoff'
YT_TOKEN = os.environ['YT_TOKEN']


def get_clid1(a, b):
    try:
        a, b = ast.literal_eval(a), ast.literal_eval(b)
        return dict(zip(a, b)).get('clid1') or 'Empty'
    except ValueError:
        return 'Empty'


CLUSTER = clusters \
    .Hahn(pool='search-research_{}'.format(USERNAME), token=YT_TOKEN) \
    .env(templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING))
JOB = CLUSTER.job()
LOG = JOB.table(RAW_LOG_TABLE)


RECORDS = LOG.qb2(
    log='metrika-mobile-log',
    fields=['device_id', 'event_date', 'event_name',
        se.log_field('Clids_Names', default="[]").rename('clids_names'),
        se.log_field('Clids_Values', default="[]").rename('clids_values')
    ],
    filters=[
        sf.default_filtering('metrika-mobile-log'),
        sf.equals('api_key_str', APIKEY),
        sf.equals('event_type', 'EVENT_CLIENT'),
        sf.one_of('event_date', list(DATES_LIST))
    ]) \
    .project('device_id', 'event_name', fielddate='event_date',
             clid1=ne.custom(get_clid1, 'clids_names', 'clids_values')) \
    .groupby('fielddate', 'event_name', 'clid1') \
    .aggregate(
        events=na.count(),
        devices=na.count_distinct('device_id', in_memory=False)) \
    .sort('fielddate', 'devices') \
    .put(OUTPUT_TABLE)
JOB.run()

# задаём конфигурацию отчёта на Статфейсе
REPORT = (
    ns.StatfaceReport()
    # задаем путь отчета, тайтл и детализацию по дням
    .path('Mobile_Soft_Launcher/events_clidded')
    .title('events')
    .scale('daily')
    # описываем измерения отчета
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('event_name').replaceable(),
        ns.StringSelector('clid1').replaceable()
    )
    # описываем метрики отчета
    .measures(
        # задаем:
        # - типы отображения полей (view types в Статфейсе)
        # - тайтлы полей
        # - параметры видимости (показывать ли метрику по умолчанию или нет)
        ns.Integer('devices').title('devices'),
        ns.Integer('events').title('events')
    )
)
# создаем клиент для публикации
client = get_stat_client()
(
    # связываем клиент с отчетом
    REPORT.client(client)
    # выгружаем результаты расчета и связываем их с отчетом
    .data(RECORDS.read())
    # публикуем данные на Статфейс
    .publish()
)

# Логируем успех
logger.warn('SUCCESS')
