#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
Takes Launcher events from metrika_mobile_log, separates by version. Draws stat report.
"""

import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

from nile.api.v1 import clusters, aggregators as na, statface as ns
from nile.files import LocalFile
from qb2.api.v1 import filters as sf
from common import (
    APPMETRIKA_LOG_PATH,
    DATES_LIST,
    JOB_ROOT,
    LAUNCHER_APIKEY,
    MAGIC_DATE_RANGE_STRING,
    USERNAME,
    get_stat_client)

output_table = '$job_root/appmetrika_events_by_version'
yt_token = os.environ['YT_TOKEN']

common_path = os.path.join(sys.path[1], 'common.py')
cluster = clusters \
    .Hahn(pool='{}'.format(USERNAME), token=yt_token) \
    .env(
        templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING),
        packages=[LocalFile(common_path)]
    )
job = cluster.job()
log = job.table(APPMETRIKA_LOG_PATH)


records = log.qb2(
    log='metrika-mobile-log',
    fields=['device_id',
        'event_date',
        'event_name',
        'app_version'],
    filters=[
        sf.defined('app_version'),
        sf.equals('api_key_str', LAUNCHER_APIKEY),
        sf.one_of('event_type', {'EVENT_CLIENT', 'EVENT_STATBOX'}),
        sf.one_of('event_date', list(DATES_LIST))
    ]) \
    .project('app_version', 'device_id', 'event_name', fielddate='event_date' ) \
    .groupby('fielddate', 'event_name', 'app_version') \
    .aggregate(
        events=na.count(),
        devices=na.count_distinct('device_id', in_memory=False)) \
    .sort('fielddate', 'devices') \
    .put(output_table)
job.run()


report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/events_by_ver')
    .title('events')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('event_name').replaceable(),
        ns.StringSelector('app_version').replaceable()
    )
    .measures(
        ns.Integer('devices').title('devices'),
        ns.Integer('events').title('events')
    )
)

client = get_stat_client()
(
    report.client(client)
    .data(records.read())
    .publish()
)
