#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

from nile.api.v1 import clusters, filters as nf, aggregators as na, extractors as ne, statface as ns
from nile.files import LocalFile
from qb2.api.v1 import filters as sf, extractors as se
from common import (
    APPMETRIKA_LOG_PATH,
    DATES_LIST,
    JOB_ROOT,
    LAUNCHER_APIKEY,
    MAGIC_DATE_RANGE_STRING,
    USERNAME,
    get_clid1,
    get_stat_client)

output_table = '$job_root/installs_by_clid'
yt_token = os.environ['YT_TOKEN']

common_path = os.path.join(sys.path[1], 'common.py')
cluster = clusters \
    .Hahn(pool='{}'.format(USERNAME), token=yt_token) \
    .env(
        templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING),
        packages=[LocalFile(common_path)]
    )
job = cluster.job()
log = job.table(APPMETRIKA_LOG_PATH)


records = log.qb2(
    log='metrika-mobile-log',
    fields=['device_id', 'event_date', 'event_type',
        se.log_field('Clids_Names', default="[]").rename('clids_names'),
        se.log_field('Clids_Values', default="[]").rename('clids_values')
    ],
    filters=[
        sf.region_belongs(master_regions=[225], dictionary='Geobase', field='geo_id'),
        sf.equals('api_key_str', LAUNCHER_APIKEY),
        sf.equals('event_name', 'first_app_launch')
    ]) \
    .project(
        'device_id',
        fielddate='event_date',
        clid=ne.custom(get_clid1, 'clids_names', 'clids_values')
    ) \
    .project(
        'device_id',
        'fielddate',
        se.unfold_with_total('clid1', 'clid', total='_total_'),
    ) \
    .filter(
        nf.custom(lambda x: x in DATES_LIST, 'fielddate')
    ) \
    .groupby('fielddate', 'clid1') \
    .aggregate(
        devices=na.count_distinct('device_id')) \
    .sort('fielddate', 'devices') \
    .put(output_table)
job.run()

report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/installs_clidded')
    .title('installs')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('clid1').replaceable()
    )
    .measures(
        ns.Integer('devices').title('devices')
    )
)

client = get_stat_client()
(
    report.client(client)
    .data(records.read())
    .publish()
)
