#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

from nile.api.v1 import clusters, filters as nf, aggregators as na, extractors as ne, statface as ns
from nile.files import LocalFile
from qb2.api.v1 import extractors as qe
from common import (
    ADNETWORK_POSTBACKS_LOG_PATH,
    DATES_LIST_APPREC,
    JOB_ROOT,
    MAGIC_DATE_RANGE_STRING_APPREC,
    USERNAME,
    date_string_from_ts,
    get_stat_client)

output_table = '$job_root/apprec_money_by_adnetwork'
yt_token = os.environ['YT_TOKEN']

common_path = os.path.join(sys.path[1], 'common.py')
cluster = clusters \
    .Hahn(pool='{}'.format(USERNAME), token=yt_token) \
    .env(
        templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING_APPREC),
        packages=[LocalFile(common_path)]
    )
job = cluster.job()
log = job.table(ADNETWORK_POSTBACKS_LOG_PATH)


records = log \
    .filter(nf.not_(nf.equals('clid', '-2'))) \
    .project(
        'payout', 'adnetwork',
        qe.unfold_with_total('adnet', 'adnetwork', total='_total_'),
        fielddate=ne.custom(date_string_from_ts, 'timestamp')
    ) \
    .groupby(
        'fielddate',
        'adnet'
    ) \
    .aggregate(
        payout=na.sum('payout'),
        postbacks_count=na.count()) \
    .sort('fielddate', 'payout') \
    .filter(nf.custom(lambda x: x in DATES_LIST_APPREC, 'fielddate')) \
    .put(output_table)
job.run()


report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/apprec_postbacks_adnetwork')
    .title('Postbacks by adnetwork')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('adnet').replaceable()
    )
    .measures(
        ns.Float('payout').title('payout'),
        ns.Integer('postbacks_count').title('postbacks_count')
    )
)
client = get_stat_client()
(
    report.client(client)
    .data(records.read())
    .publish(smart_update_config=True, upload_config=False)
)
