#!/usr/bin/env python
#! -*- coding: utf-8 -*-
import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

from nile.api.v1 import clusters, filters as nf, aggregators as na, extractors as ne, statface as ns
from nile.files import LocalFile
from qb2.api.v1 import filters as sf

from common import (
    ADNETWORK_POSTBACKS_LOG_PATH,
    DATES_LIST_APPREC,
    JOB_ROOT,
    MAGIC_DATE_RANGE_STRING_APPREC,
    USERNAME,
    ts_to_msk_date,
    get_stat_client)


output_table = '$job_root/apprec_money_total'
yt_token = os.environ['YT_TOKEN']


def make_report():
    common_path = os.path.join(sys.path[1], 'common.py')
    cluster = clusters \
        .Hahn(pool='{}'.format(USERNAME), token=yt_token) \
        .env(
            templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING_APPREC),
            packages=[LocalFile(common_path)]
        )
    job = cluster.job()
    log = job.table(ADNETWORK_POSTBACKS_LOG_PATH)
    records = log \
        .filter(sf.defined('payout', 'click_timestamp')) \
        .project('payout', fielddate = ne.custom(ts_to_msk_date, 'click_timestamp')) \
        .groupby('fielddate') \
        .aggregate(payout_daily=na.sum('payout'), postbacks_count=na.count()) \
        .filter(nf.custom(lambda x: x in DATES_LIST_APPREC, 'fielddate')) \
        .put(output_table)
    job.run()

    report = (ns.StatfaceReport()
        .path('Mobile_Soft_Launcher/postbacks')
        .title('AppRec Postbacks')
        .scale('daily')
        .dimensions(ns.Date('fielddate').replaceable())
        .measures(
            ns.Float('payout_daily').title('payout'),
            ns.Integer('postbacks_count').title('postbacks_count')))
    client = get_stat_client()
    (
        report.client(client)
        .data(records.read())
        .publish()
    )


def main():
    make_report()


if __name__ == '__main__':
    main()
