#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

import os
from nile.api.v1 import clusters, filters as nf, aggregators as na, extractors as ne, statface as ns
from nile.files import LocalFile
from qb2.api.v1 import filters as qf, extractors as qe
from common import (
    APPMETRIKA_LOG_PATH,
    DATES_LIST,
    JOB_ROOT,
    LAUNCHER_APIKEY,
    MAGIC_DATE_RANGE_STRING,
    USERNAME,
    get_clid1,
    get_stat_client)

output_table = '$job_root/devices_clid1'
yt_token = os.environ['YT_TOKEN']
common_path = os.path.join(sys.path[1], 'common.py')
cluster = clusters \
    .Hahn(pool='{}'.format(USERNAME), token=yt_token) \
    .env(
        templates=dict(job_root=JOB_ROOT, date=MAGIC_DATE_RANGE_STRING),
        packages=[LocalFile(common_path)],
        yt_spec_defaults=dict(
            pool_trees=["physical"],
            tentative_pool_trees=["cloud"]
        )
    )

job = cluster.job()
log = job.table(APPMETRIKA_LOG_PATH)


records = log.qb2(
    log='metrika-mobile-log',
    fields=['device_id', 'event_date',
            qe.expression(
                'is_russia',
                qf.region_belongs(master_regions=[225], dictionary='Geobase',
                field='geo_id')
            ),
            qe.log_field('Clids_Names', default="[]").rename('clids_names'),
            qe.log_field('Clids_Values', default="[]").rename('clids_values')],
    filters=[
        qf.equals('api_key_str', LAUNCHER_APIKEY),
        qf.equals('session_type', 'SESSION_FOREGROUND'),
        qf.one_of('event_type', {'EVENT_CLIENT', 'EVENT_STATBOX'}),
    ]
).project(
    'device_id', 'is_russia',
    fielddate='event_date',
    clid1=ne.custom(get_clid1, 'clids_names', 'clids_values')
).project(
    'device_id', 'fielddate',
    qe.unfold_with_total('is_ru', 'is_russia', total='_total_'),
    qe.unfold_with_total('clid', 'clid1', total='_total_')
)

result = records \
    .filter(
        nf.custom(lambda x: x in DATES_LIST, 'fielddate')
    ) \
    .groupby('fielddate', 'clid', 'is_ru') \
    .aggregate(
        events=na.count(),
        devices=na.count_distinct('device_id', in_memory=False)
    ) \
    .sort('fielddate', 'devices') \
    .put(output_table)


job.run()


report = (
    ns.StatfaceReport()
    .path('Mobile_Soft_Launcher/audience')
    .title('audience')
    .scale('daily')
    .dimensions(
        ns.Date('fielddate').replaceable(),
        ns.StringSelector('clid').replaceable(),
        ns.StringSelector('is_ru').replaceable()
    )
    .measures(
        ns.Integer('devices').title('Девайсы'),
        ns.Integer('events').title('События')
    )
)

client = get_stat_client()

(
    report.client(client)
    .data(result.read())
    .publish()
)
