#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
sys.path.insert(1, os.path.join(sys.path[0], '../..'))

import json
import requests
from nile.api.v1 import statface as ns
from common import (
    DATES_LIST,
    DISTRIBUTION_REPORT_URL,
    get_stat_client)

DISTRIBUTION_TOKEN = os.environ['DISTRIBUTION_TOKEN']


def request_report(params):
    headers = {
        'Authorization': 'OAuth {}'.format(DISTRIBUTION_TOKEN)
    }
    response = requests.post(
        DISTRIBUTION_REPORT_URL,
        data=params,
        headers=headers
    )
    response.raise_for_status()
    return response.json()


def fetch(fielddate):
    params = json.dumps(
        {
            'dimensions': ['clid'],
            'filters': [
                'AND',
                    [['soft_id', '=', '1029'],
                    ['clid_type_id', '=', '1003']]
            ],
            'measures': ['turnover_all', 'turnover_direct', 'searches'],
            'period': [fielddate, fielddate],
            'currency_convertation': '1'
        }
    )
    return request_report(params)


def get_possible_dimensions():
    URL = "https://distribution.yandex.net/api/v2/statistics/basic?lang=en&oauth_token={}".format(DISTRIBUTION_TOKEN)
    response = requests.get(URL)
    return response.json()


def process(fielddate):
    data = []
    report = fetch(fielddate)

    report = report['data']['report']
    grand_total = 0.0
    searches_total = 0.0
    for i in report:
        clid_total = 0.0
        clid_searches = 0.0
        clid = ''
        for measure in i['measures']:
            if measure['name'] == 'turnover_direct':
                clid_total += measure.get('value') or 0
                grand_total += measure.get('value') or 0
            elif measure['name'] == 'searches':
                clid_searches += measure.get('value') or 0
                searches_total += measure.get('value') or 0
        for dim in i['dimensions']:
            if dim['name'] == 'clid':
                clid = dim.get('value') or ''
        data.append(
            {
                'fielddate': fielddate,
                'revenue': clid_total,
                'searches': clid_searches,
                'clid1003': clid
            }
        )
    data.append(
        {
            'fielddate': fielddate,
            'revenue': grand_total,
            'searches': searches_total,
            'clid1003': '_total_'
        }
    )
    return data


def publish(data):
    report = (
        ns.StatfaceReport()
        .path('Mobile_Soft_Launcher/search_revenue')
        .title('search_revenue')
        .scale('daily')
        .dimensions(
            ns.Date('fielddate').replaceable(),
            ns.StringSelector('clid1003').replaceable()
        )
        .measures(
            ns.Float('revenue').title('Search Widget Revenue (USD)'),
            ns.Integer('searches').title('Search Widget Searches')
        )
    )
    client = get_stat_client()
    (
        report.client(client)
        .data(data)
        .publish()
    )


def main():
    for d in DATES_LIST:
        print d
        data = process(d)
        publish(data)
        print 'Published:\n{}'.format(data)
#    print fetch('2018-07-05')
#    pprint(get_possible_dimensions())


if __name__ == '__main__':
    main()
