#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
from datetime import date, timedelta

from nile.api.v1 import statface as ns
from nile.api.v1.datetime import date_range

weeks_recalc_back = 4
aggregat_table_path = 'home/advisor/agregat/@date'
date_end = date.today() - timedelta(days=1)
date_start = date_end - timedelta(weeks=weeks_recalc_back)
dates_list = list(date_range(date_start, date_end, step=1, stringify=True))
distribution_url = "https://distribution.yandex.net/api/v2/statistics/basic/report/?lang=ru"
job_root = 'home/advisor/reports/phone'
# '{2017-01-01..2017-10-31}'
magic_date_range_string = '{%s..%s}' % (date_start, date_end)
username = ''
STAT_TOKEN = os.environ.get('STATFACE_TOKEN', '')


def clid_parser(fname):
    result = {}
    script_dir = os.path.dirname(__file__)
    abs_file_path = os.path.join(script_dir, fname)
    with open(abs_file_path) as fr:
        for line in fr:
            if line.startswith('<vendor'):
                vendor = line.strip().split('name="')[1].split('.')[0]
            elif '<clid' in line:
                clid_value = line.strip().split('>')[1].split('<')[0]
                result[clid_value] = vendor
    return result


def get_stat_client():
    return ns.StatfaceProductionClient(
        token=STAT_TOKEN
    )

def get_city(lbs_info):  # TODO: get name of region
    if not lbs_info:
        return
    region_ids = lbs_info.get('region_ids')
    region_types = lbs_info.get('region_types')
    if not region_ids or not region_types:
        region_ids = lbs_info.get('region_ids_init')
        region_types = lbs_info.get('region_types_init')
        if not region_ids or not region_types:
            return

    if 6 in region_types:
        precise_type = 6
    else:
        precise_type = max(region_types)
    return region_ids[region_types.index(precise_type)]
