#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
from datetime import date

from nile.api.v1 import clusters, aggregators as na, extractors as ne
from nile.files import LocalFile
from qb2.api.v1 import filters as qf, extractors as qe

# Calculate Yandex.Phone DAU geo distribution.
from common import get_city

if __name__ == '__main__':
    output_table = '//home/advisor/reports/phone/server_dau_geo'
    input_table = '//home/advisor/users_full'
    yt_token = os.environ['YT_TOKEN']
    fielddate = date.today().isoformat()
    common_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'common.py')
    cluster = clusters.yt.Hahn(pool='', token=yt_token).env(packages=[LocalFile(common_path)])

    job = cluster.job()
    records = job.table(
        input_table
    ).filter(
        qf.nonzero('phone_id')
    ).project(
        'phone_id',
        updated_at=qe.integer_dictitem('$date', from_='updated_at'),
        region=ne.custom(get_city, 'lbs_info'),
    ).groupby(
        'phone_id'
    ).top(
        1,
        'updated_at'
    ).groupby(
        'region'
    ).aggregate(
        devices=na.count()
    ).project(
        ne.all(),
        fielddate=ne.const(fielddate)
    ).put(output_table, append=True)

    job.run()
